import Avatar from '@mui/material/Avatar';
import Tooltip from '@mui/material/Tooltip';
import ListItem from '@mui/material/ListItem';
import ListItemText from '@mui/material/ListItemText';
import { collaborator } from '@/contexts/types/Project';

// ----------------------------------------------------------------------

type Props = {
  person: collaborator;
};

export default function ProjectInvitedItem({ person }: Props) {
  return (
    <ListItem
      sx={{
        px: 0,
        py: 1,
      }}
    >
      <Avatar alt={person.user.firstName} sx={{ mr: 2 }}>
        {person.user.firstName.charAt(0).toUpperCase()}
      </Avatar>

      <ListItemText
        primary={`${person.user.firstName} ${person.user.lastName}`}
        secondary={
          <Tooltip title={person.user.email}>
            <span>{person.user.email}</span>
          </Tooltip>
        }
        primaryTypographyProps={{ noWrap: true, typography: 'subtitle2' }}
        secondaryTypographyProps={{ noWrap: true, component: 'span' }}
        sx={{ flexGrow: 1, pr: 1 }}
      />
    </ListItem>
  );
}
