import { useState, useEffect } from 'react';
import { ITaskItem } from '@/contexts/types/tasks';
import { Button, Dialog, DialogActions, DialogContent, DialogTitle, Divider } from '@mui/material';
import AddMarkToTasks from './add-mark-to-tasks';

interface Props {
    open: boolean;
    onClose: VoidFunction;
    task: ITaskItem | null;
    onSuccess: (updatedTask: ITaskItem) => void;
}

export default function RewardAddMarkDialog({ task, open, onClose, onSuccess }: Props) {
    const [note, setNote] = useState('');

    useEffect(() => {
        if (task) {
            setNote('');
        }
    }, [task]);

    const handleAddMark = (updatedTask: ITaskItem) => {
        onSuccess(updatedTask);
        onClose();
    };

    return (
        <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose}>
            <DialogTitle>
                {task ? `Add Mark to Task: ${task.name}` : 'Add Mark to Task'}
            </DialogTitle>
            <DialogContent sx={{ overflow: 'unset', p: 3, overflowY: 'hidden' }}>
                <AddMarkToTasks
                    rewardId={task ? task.id : 0}
                    title={task ? `Add mark to ${task.name}` : 'Add mark to task'}
                    description={task ? task.description || 'No description provided.' : ''}
                    onSuccess={handleAddMark}
                />
            </DialogContent>
            <Divider sx={{ borderStyle: 'solid' }} />
            <DialogActions sx={{ justifyContent: 'space-between' }}>
                <Button variant="outlined" color="inherit" onClick={onClose}>
                    Close
                </Button>
            </DialogActions>
        </Dialog>
    );
}