import { useResponsive } from "@/hooks";
import { SeoIllustration } from "@/shared/assets/illustrations";
import Iconify from "@/shared/components/iconify"
import { LoadingButton } from "@mui/lab"
import { Card, CardHeader, Grid, Stack, Typography } from "@mui/material"
import { useState } from "react";

export default function DownloadFile()
{
    const mdUp = useResponsive('up', 'md');
    const [downloading, setDownloading] = useState(false);
    const handleDownloadClick = () => {
      setDownloading(true);
    }
    setTimeout(() => {
      setDownloading(false);
    }, 2000);
  
    const renderDetails = (
        <Grid xs={12} md={12}  mt={4} >
          <Card>
             <CardHeader title="Video advertising editing" />
            <Stack spacing={3} sx={{ m: 4 }}>
            <Typography variant="body2"  sx={{ color: 'text.secondary',pl:"-12px"}}>Hello, you will find in this link the video you requested, as well as a descriptive PDF</Typography>

             <Stack spacing={1}>
            </Stack>
          </Stack>
          </Card>
        </Grid>)
    const renderActions =  (
        <>
        {mdUp && <Grid md={4} />}
        <Grid xs={12} md={8} mt={3}>
        <LoadingButton  
            variant="contained"
            size="large"  
            startIcon={<Iconify icon="eva:cloud-download-fill" />}
            onClick={handleDownloadClick} 
            loading={downloading} 
  >
    {downloading ? 'Downloading...' : 'Download'} 
  </LoadingButton>
        </Grid>
      </>)
      return(
<Grid container spacing={3} sx={{
          justifyContent: 'center'
        }}>
        <Grid xs={12} md={12} >
        <Stack
          component="span"
          justifyContent="center"
          sx={{
            maxWidth: 200,
            mx: 'auto',
          }}
        >
        <SeoIllustration />
        </Stack>
            {renderDetails}
            {renderActions}
          </Grid>
        </Grid>
        )
}                   
