import {
    Card,
    CardHeader,
    InputAdornment,
    Stack,
    styled,
    Typography,
  } from '@mui/material';
  import AutoFixNormalIcon from '@mui/icons-material/AutoFixNormal';
  import { RHFRadioGroup, RHFTextField } from '@/shared/components/hook-form';
  import FileUpload from './file-uploaded';

  
  
  interface TransferDetailsFormProps {
    currentType: string;
    setValue: any;
    watch: any;
    errors: any;
    handleTypeChange: (event: React.ChangeEvent<HTMLInputElement>) => void;
  }
  const StyledLabel = styled('span')(({ theme }) => ({
    ...theme.typography.caption,
    width: 100,
    flexShrink: 0,
    color: theme.palette.text.secondary,
    fontWeight: theme.typography.fontWeightSemiBold,
  }));
  
  export default function TransferDetailsForm({
    currentType,
    setValue,
    watch,
    errors,
    handleTypeChange,
  }: TransferDetailsFormProps) {
    const Option_Transfer = [
      { value: 'email', label: 'Email' },
      { value: 'link', label: 'Link' },
    ];
  
    return (
      <Card>
        <CardHeader title="Upload your files" />
        <Stack spacing={3} sx={{ m: 4 }}>
          <RHFTextField name="title" label="Transfer Title" />
  
          <Stack spacing={1}>
            <RHFTextField
              multiline
              rows={3}
              name="message"
              label="Transfer Message"
              InputProps={{
                endAdornment: (
                  <InputAdornment position="end" sx={{ marginBottom: '-40px' }}>
                    <AutoFixNormalIcon />
                  </InputAdornment>
                ),
              }}
            />
          </Stack>
  
          <Stack spacing={1}>
            <Typography variant="subtitle2">Transfer Type</Typography>
            <RHFRadioGroup
              row
              spacing={4}
              name="type"
              options={Option_Transfer}
              onChange={handleTypeChange}
            />
          </Stack>
          {(currentType === 'email' || currentType === '') && (
  <Stack spacing={1}>
    <RHFTextField name="email_to" label="Send to" type="email" />
  </Stack>
)}
  
          <Stack direction="row">
            <StyledLabel>Files</StyledLabel>
            <FileUpload setValue={setValue} files={watch('files')} error={errors.files?.message} />
          </Stack>
        </Stack>
      </Card>
    );
  }