'use client';

import { Grid } from '@mui/material';
import { LoadingButton } from '@mui/lab';
import FormProvider from '@/shared/components/hook-form';
import Iconify from '@/shared/components/iconify';
import UrlsDialog from './urls-dialog';
import { useTransferNewFile } from '@/hooks/use-transfer-new-file';
import TransferDetailsForm from './transfer-details-form';

export default function TransferNewFileView() {
  const {
    methods,
    isLoading,
    urlsDialog,
    handleSubmit,
    handleTypeChange,
    handleCloseUrlsDialog,
  } = useTransferNewFile();

  const {
    watch,
    setValue,
    formState: { errors, isSubmitting },
  } = methods;

  const currentType = watch('type');

  const renderActions = currentType === 'link' ? (
    <LoadingButton
      type="submit"
      variant="contained"
      size="large"
      sx={{
        backgroundColor: '#144dd5',
        '&:hover': {
          backgroundColor: '#144dd5',
        },
    
        textTransform: 'none',
        px: 2,
        marginLeft: 2,
      }}
      loading={isSubmitting || isLoading}
      startIcon={<Iconify icon="eva:link-2-fill" />}
    >
      Generate Links
    </LoadingButton>
  ) : (
    <LoadingButton
      type="submit"
      variant="contained"
      size="large"
      sx={{
        backgroundColor: '#144dd5',
        '&:hover': {
          backgroundColor: '#144dd5',
        },
    
        textTransform: 'none',
        px: 2,
        marginLeft: 2,
      }}
      loading={isSubmitting || isLoading}
      startIcon={<Iconify icon="iconamoon:send-fill" />}
    >
      Transfer
    </LoadingButton>
  );

  return (
    <FormProvider methods={methods} onSubmit={methods.handleSubmit(handleSubmit)}>
      <Grid container spacing={3} sx={{ justifyContent: 'center' }}>
        <Grid xs={12} md={8}>
          <Grid xs={12} md={12} mt={7}>
            <TransferDetailsForm
              currentType={currentType}
              setValue={setValue}
              watch={watch}
              errors={errors}
              handleTypeChange={handleTypeChange}
            />
          </Grid>
          <Grid xs={12} md={8} mt={3}>
            {renderActions}
          </Grid>
        </Grid>
      </Grid>
      
      <UrlsDialog 
        open={urlsDialog.open}
        urls={urlsDialog.urls}
        onClose={handleCloseUrlsDialog}
      />
    </FormProvider>
  );
}