import React, { useCallback, useState } from 'react';
import Iconify from "@/shared/components/iconify";
import { Button, Checkbox, Dialog, DialogActions, DialogContent, DialogTitle, FormControl, InputLabel, MenuItem, OutlinedInput, Select, SelectChangeEvent } from "@mui/material";

type Props = {
  open: boolean;
  onClose: VoidFunction;
  roleOptions: string[];
  onCopyLink: VoidFunction;
};

export default function DialogInviteUser({ open, onClose, roleOptions, onCopyLink }: Props) {
  const [selectedRoles, setSelectedRoles] = useState<string[]>([]);


const handleRoleSelect = useCallback(
(event: SelectChangeEvent<string | string[]>) => {
    setSelectedRoles (typeof event.target.value === 'string' ? event.target.value.split(',') : event.target.value);

  },[])

  return (
    <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose}>
      <DialogTitle>Invite User</DialogTitle>
      <DialogContent sx={{ overflow: 'unset' }}>
        <FormControl
          sx={{
            flexShrink: 0,
            width: { xs: 1, md: 200 },
          }}
        >
          <InputLabel>Role</InputLabel>
          <Select
            multiple
            value={selectedRoles}
            onChange={handleRoleSelect}
            input={<OutlinedInput label="Role" />}
            MenuProps={{
              PaperProps: {
                sx: { maxHeight: 240 },
              },
            }}
          >
            {roleOptions.map((option) => (
              <MenuItem key={option} value={option}>
                <Checkbox checked={selectedRoles.includes(option)} size="small" />
                {option}
              </MenuItem>
            ))}
          </Select>
        </FormControl>
      </DialogContent>
      <DialogActions sx={{ justifyContent: 'space-between' }}>
        {onCopyLink && (
          <Button startIcon={<Iconify icon="eva:link-2-fill" />} onClick={onCopyLink}>
            Copy link
          </Button>
        )}
        {onClose && (
          <Button variant="outlined" color="inherit" onClick={onClose}>
            Close
          </Button>
        )}
      </DialogActions>
    </Dialog>
  );
}
