import { SxProps } from '@mui/material/styles';

export const styles = {
  emptyDataContainer: {
    p: 3,
    textAlign: 'center',
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    width: '100%'
  } as SxProps,
  
  chartContainer: (height: number) => ({
    width: '100%',
    height: height,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  }) as SxProps
};

export const getChartOptions = (theme: any, series: any, options: any) => {
  return {
    chart: {
      type: 'bar',
      toolbar: {
        show: false,
      },
    },
    plotOptions: {
      bar: {
        horizontal: true,
        barHeight: '50%',
        borderRadius: 4,
        distributed: true,
        dataLabels: {
          position: 'top',
        },
      },
    },
    dataLabels: {
      enabled: true,
      formatter: function (val: number) {
        return val + ' days';
      },
      offsetX: 20,
      style: {
        fontSize: '12px',
        colors: [theme.palette.text.primary]
      }
    },
    colors: [
      theme.palette.primary.main,
      theme.palette.info.main,
      theme.palette.warning.main,
      theme.palette.error.main,
      theme.palette.success.main,
    ],
    xaxis: {
      categories: series[0].axis,
      title: {
        text: 'Days Remaining',
      },
      labels: {
        formatter: function (val: string | number) {
          return Math.round(Number(val)).toString();
        }
      }
    },
    yaxis: {
      title: {
        text: 'Projects',
      },
      labels: {
        maxWidth: 150,
        style: {
          fontSize: '12px',
        }
      }
    },
    tooltip: {
      y: {
        title: {
          formatter: function () {
            return 'Project:';
          }
        }
      },
      x: {
        formatter: function (val: number) {
          return val + ' days remaining';
        }
      }
    },
    legend: {
      show: false,
    },
    grid: {
      xaxis: {
        lines: {
          show: true,
        },
      },
      yaxis: {
        lines: {
          show: false,
        },
      },
    },
    ...options,
  };
}; 