/* import { IChatConversation, IChatConversations, IChatParticipant } from "@/shared/types/chat";


export function getParticipantDisplayInfo(participant: IChatParticipant, activateAnonymity: boolean) {
    if (activateAnonymity) {
        console.log(participant)
        return {
            id: participant.id,
            name: participant.role,
            role: participant.role,
            email: 'user@anonymous.com',
            address: 'Anonymous Address',
            avatarUrl: '#',
            phoneNumber: 'Generic Phone Number',
            lastActivity: participant.lastActivity,
            status: participant.status,
        };
    }
    return participant;
}

export function updateConversationParticipants(conversation: IChatConversation, anonymityEnabled: boolean): IChatConversation {
    // Creer une copie de la conversation pour eviter les mutations directes
    const updatedConversation = { ...conversation };

    updatedConversation.participants = updatedConversation.participants.map((participant) => {
        return getParticipantDisplayInfo(participant, anonymityEnabled);
    });

    return updatedConversation;
}

export function updateConversationsWithParticipants(conversations: IChatConversations, anonymityEnabled: boolean): IChatConversations {
    const updatedById: Record<string, IChatConversation> = {};

    conversations.allIds.forEach((conversationId) => {
        const conversation = conversations.byId[conversationId];
        // Vérifier le type de la conversation
        if (conversation.type === 'GROUP') {
            // Mettre à jour les participants de la conversation
            const updatedConversation = updateConversationParticipants(conversation, anonymityEnabled);
            updatedById[conversationId] = updatedConversation;
        } else {
            // Ingore les participants pour les conversations de type 'ONE_TO_ONE'
            updatedById[conversationId] = conversation;
        }
    });

    return {
        byId: updatedById,
        allIds: conversations.allIds,
    };
}
 */