/**
 * Check if the current user is either an admin or a manager
 * @returns boolean indicating if user has admin or manager permissions
 */
export const checkManagerOrAdmin = (): boolean => {
  try {
    // Get roles from localStorage
    const roles = JSON.parse(localStorage.getItem('role') || '[]');
    const agencyRoles = JSON.parse(localStorage.getItem('agency_role') || '{}');
    
    // Check if user is admin
    const isAdmin = Array.isArray(roles) && roles.includes('ADMIN');
    
    // Check if user is manager in any agency
    const isManager = Object.values(agencyRoles).some(
      role => typeof role === 'string' && role.toUpperCase() === 'MANAGER'
    );
    
    return isAdmin || isManager;
  } catch (error) {
    console.error('Error checking permissions:', error);
    return false;
  }
};

export default {
  checkManagerOrAdmin,
}; 