'use client'
import { createContext, useContext, useState } from 'react';

type AgencyUpdatesContextType = {
  refreshAgencyList: () => void;
  setRefreshAgencyList: (callback: () => void) => void;
};

const AgencyUpdatesContext = createContext<AgencyUpdatesContextType | null>(null);

export function AgencyUpdatesProvider({ children }: { children: React.ReactNode }) {
  const [refreshAgencyList, setRefreshAgencyList] = useState<() => void>(() => {});

  return (
    <AgencyUpdatesContext.Provider value={{ refreshAgencyList, setRefreshAgencyList }}>
      {children}
    </AgencyUpdatesContext.Provider>
  );
}

export const useAgencyUpdates = () => {
  const context = useContext(AgencyUpdatesContext);
  if (!context) throw new Error('useAgencyUpdates must be used within AgencyUpdatesProvider');
  return context;
}; 