import { useMemo } from 'react';
import merge from 'lodash/merge';

import { CALENDAR_COLOR_OPTIONS } from '@/shared/_mock/_calendar';

import { ICalendarRange, ICalendarEvent, ICalendarEventWithRecurrent, DialogData } from '@/shared/types/calendar';

// ----------------------------------------------------------------------

export default function useEvent(
  events: ICalendarEventWithRecurrent[],
  selectEventId: string,
  selectedRange: ICalendarRange,
  openForm: boolean
) {
  const currentEvent = events.find((event) => event.id === selectEventId);

  const defaultValues: ICalendarEventWithRecurrent = useMemo(
    () => ({
      id: '',
      title: '',
      description: '',
      color: CALENDAR_COLOR_OPTIONS[1],
      allDay: false,
      start: selectedRange ? new Date(selectedRange.start) : new Date(),
      end: selectedRange ? new Date(selectedRange.end) : new Date(),
      guests: [], 
      timeZone: '',
      notification: '',
      recurring: {} as DialogData
    }),
    [selectedRange]
  );

  if (!openForm) {
    return undefined;
  }

  if (currentEvent || selectedRange) {
    return merge({}, defaultValues, currentEvent);
  }

  return defaultValues;
}
