import { IChatMessage, IChatParticipant, IClient } from '@/shared/types/chat';
import { useMockedUser } from './use-mocked-user';

// ----------------------------------------------------------------------

type Props = {
  message: IChatMessage;
  currentUserId: string;
  participants: IClient[];
};

export default function useGetMessage({ message, participants, currentUserId }: Props) {

  const { user1 } = useMockedUser();

/*   const sender = participants.filter(participant => participant.uuid !== user1.uuid)[0]; //CHANGES
 */
     const sender = participants?.filter(participant => participant.uuid !== currentUserId)[0] || null;

  const uuidsender = message?.owner?.uuid != undefined ? message.owner.uuid : message.sourceUuid;

  const senderDetails =
    (uuidsender === user1.uuid)
      ? {
        type: 'me',
      }
      : {
        avatarUrl: sender?.avatarUrl,
        firstName: sender?.firstname.split(' ')[0],
      };
  const me = senderDetails.type === 'me';
  // confirm("sender :" + message.owner.uuid + " receiver :" + user1.uuid)
  const hasImage = message.type === 'image';

  return {
    hasImage,
    me,
    senderDetails,
  };
}
