import useSWR from 'swr';
import { listInvoiceClient, createInvoiceClient } from '@/shared/api/invoice';
import { IInvoiceClient } from '@/shared/types/invoice';
const INVOICE_CLIENTS_KEY = '/api/invoice-client/list';
export function useInvoiceClient() {
 const { data: clients, error, isLoading, mutate } = useSWR(
   INVOICE_CLIENTS_KEY, 
   listInvoiceClient
 );
  const addClient = async (newClient: IInvoiceClient) => {
   try {
     const response = await createInvoiceClient(newClient);
     
     // Forcer le rafraîchissement de la liste
     await mutate();
     
     // Retourner directement les données du client créé
     return response.data;
   } catch (error) {
     console.error('Error in addClient:', error);
     throw error;
   }
 };
  return {
   clients: clients || [], // Assurer qu'on retourne toujours un tableau
   isLoading,
   error,
   addClient,
 };
}