import { _mock } from '@/shared/_mock';
import { useAuthContext } from './use-auth-context';
import { useGetUserInfos } from '@/shared/api/chat javalin';

// TO GET THE USER FROM THE AUTHCONTEXT, YOU CAN USE

// CHANGE:
// import { useMockedUser } from 'src/hooks/use-mocked-user';
// const { user } = useMockedUser();

// TO:
// import { useAuthContext } from 'src/auth/hooks';
// const { user } = useAuthContext();

// ----------------------------------------------------------------------



export function useMockedUser() {

  const { user } = useAuthContext();

  // const { connectedClient } = useGetUserInfos(1);

  const { connectedClient, contactsLoading, contactsError, contactsValidating, contactsEmpty } = useGetUserInfos(user?.id - 10);

  if (contactsLoading) {
    console.log('Loading user information...');
  }

  if (contactsError) {
    console.error('Error fetching user information:', contactsError);
  }

  let user1;

  if (connectedClient) {
    // console.log('User information:', connectedClient);

    user1 = {
      id: connectedClient.id,
      uuid: connectedClient.uuid,
      displayName: connectedClient.firstname,
      email: connectedClient.username,
      password: '',
      photoURL: connectedClient.avatarUrl,
      phoneNumber: '+40 777666555',
      about: 'Praesent turpis. Phasellus viverra nulla ut metus varius laoreet. Phasellus tempus.',
      role: 'admin',
      isPublic: true,
      usernameType: 'EMAIL',
      username: connectedClient.username,
      lastActivity: new Date(),
      firstname: connectedClient.firstname,
      lastname: connectedClient.lastname,
      avatarUrl: connectedClient.avatarUrl,
      status: 'online',
    };
  } else {
    user1 = {
      id: '',
      uuid: '',
      displayName: '',
      email: '',
      password: '',
      photoURL: '',
      phoneNumber: '',
      about: '',
      role: '',
      isPublic: false,
      usernameType: '',
      username: '',
      lastActivity: new Date(),
      firstname: '',
      lastname: '',
      avatarUrl: '',
      status: 'offline',
    };
  }

  return { user1 };
}
