import { _id, _postTitles } from '@/shared/_mock/assets';
// ----------------------------------------------------------------------
const ROOTS = {
  AUTH: '/auth',
  DASHBOARD: '/dashboard',
};

const MOCK_ID = _id[1];


// ----------------------------------------------------------------------
export const paths = {
  minimalUI: 'https://mui.com/store/items/minimal-dashboard/',
  // AUTH
  auth: {
    jwt: {
      login: `${ROOTS.AUTH}/jwt/login`,
      register: `${ROOTS.AUTH}/jwt/register`,
    },
    forgotPassword: `${ROOTS.AUTH}/forgot-password`,
    verifyEmail: (token: string) => `/auth/verify-email?token=${token}`,
    newPassword: `${ROOTS.AUTH}/new-password`,
  },
  // DASHBOARD
  dashboard: {
    root: ROOTS.DASHBOARD,
    
    group: {
      root: `${ROOTS.DASHBOARD}/group`,
    
    },

    projects: {
      root: '/dashboard/project_management/projects',
      recent: '/dashboard/project_management/projects/recent',
      internal: '/dashboard/project_management/projects/internal',
      external: '/dashboard/project_management/projects/external',
      add_project: `${ROOTS.DASHBOARD}/project_management/projects/add-project`,
      all_projects: `${ROOTS.DASHBOARD}/project_management/projects/all-projects`,
      edit_project: (id: number) => `${ROOTS.DASHBOARD}/project_management/projects/${id}/edit`,
      project_details: (id: number) => `${ROOTS.DASHBOARD}/project_management/projects/${id}/project-details`
    },
    rewards: {
      root: `${ROOTS.DASHBOARD}/project_management/rewards/all-rewards`,
      add_reward: `${ROOTS.DASHBOARD}/project_management/rewards/add-reward`,
      all_rewards: `${ROOTS.DASHBOARD}/project_management/rewards/all-rewards`,
      all_winners: `${ROOTS.DASHBOARD}/project_management/rewards/all-winners`,
      reward_details: (id: string) => `${ROOTS.DASHBOARD}/project_management/rewards/${id}`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/project_management/rewards/${id}/edit`,
    },
    tasks: {
      root: `${ROOTS.DASHBOARD}/project_management/tasks`,
      add_task: `${ROOTS.DASHBOARD}/project_management/tasks/add-task`,
      all_tasks: `${ROOTS.DASHBOARD}/project_management/tasks/all-tasks`,
      details: (id: string) => `${ROOTS.DASHBOARD}/project_management/tasks/all-tasks/${id}`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/project_management/tasks/${id}/edit`,
    },
    kanban:{
      root: `${ROOTS.DASHBOARD}/project_management/kanban`,
      add_kanban: `${ROOTS.DASHBOARD}/project_management/kanban/add-kanban`,
      all_kanban: `${ROOTS.DASHBOARD}/project_management/kanban/all-kanban`,
      details: (id: string) => `${ROOTS.DASHBOARD}/project_management/kanban/${id}`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/project_management/kanban/${id}/edit`,
    },
    invoice: {
      root: `${ROOTS.DASHBOARD}/invoice`,
      new: `${ROOTS.DASHBOARD}/invoice/new`,
      analytics: `${ROOTS.DASHBOARD}/invoice/analytics`,
      grid: `${ROOTS.DASHBOARD}/invoice/grid`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/invoice/${id}/edit`,
      details: (id: string) => `${ROOTS.DASHBOARD}/invoice/${id}`,
    },
    agency: {
      root: `${ROOTS.DASHBOARD}/agency`,
      create: `${ROOTS.DASHBOARD}/agency/create`,
      createUserAgency: `${ROOTS.DASHBOARD}/agency/user`,
      list: `${ROOTS.DASHBOARD}/agency/allAccountAgency`,
      edit: (id: string) => `${ROOTS.DASHBOARD}/agency/${id}/edit`,
      details: (id: string) => `${ROOTS.DASHBOARD}/agency/${id}/details`,
      groupe:
      {
        list: `${ROOTS.DASHBOARD}/agency/groups`,
        edit: (id: string) => `${ROOTS.DASHBOARD}/agency/groupe/${id}/edit`,
        add: (agencyId: string) => `${ROOTS.DASHBOARD}//agency/groupe/add`,
        details: (id: string) => `${ROOTS.DASHBOARD}/agency/groupe/${id}/details`,

      }
    
    },
    user: {
      root: `${ROOTS.DASHBOARD}/user`,
      demo: {
        edit: `${ROOTS.DASHBOARD}/user/${MOCK_ID}/edit`,
        details: `${ROOTS.DASHBOARD}/user/${MOCK_ID}/details`,
      },
     
    },
    transfer: {
      root: `${ROOTS.DASHBOARD}/transfer-file`,
      new: `${ROOTS.DASHBOARD}/transfer-file/new`,
      download: (id: string) => `${ROOTS.DASHBOARD}/transfer-file/download/${id}`,

    },
    calendar: `${ROOTS.DASHBOARD}/calendar`,
    chat: `${ROOTS.DASHBOARD}/chat`,
    // Add the new manager path
    manager: `${ROOTS.DASHBOARD}/manager`,
    userAgency: `${ROOTS.DASHBOARD}/userAgency`,
    filemanager: {
      root: `${ROOTS.DASHBOARD}/file-manager`,
      sharedFiles: `${ROOTS.DASHBOARD}/file-manager/shared`,
      personnalFiles: `${ROOTS.DASHBOARD}/file-manager/personnalFiles`,
      sharedWithMe:`${ROOTS.DASHBOARD}/file-manager/sharedWithMe`,
      sharedDocument:(uniqueId: string, token: string) => 
        `${ROOTS.DASHBOARD}/file-manager/sharedWithMe/${uniqueId}?token=${token}`,
       
      },
    
  
  },

  

};
