import { _mock } from "./_mock";

// Définition d'un tableau contenant les noms des groupes
const groupeName = [
  { name: 'InnovateTech Group' },
  { name: 'EliteVentures Corporation' },
  { name: 'NexusAlliance Holdings' },
  { name: 'Freight Forwarders Inc.' },
  { name: 'ApexStrategic Group' },
  { name: 'SynergyWorks Incorporated' }
];

// Définition d'un participant
const createParticipant = (index:any) => ({
  id: _mock.id(index),
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  phoneNumber: _mock.phoneNumber(index),
  email: _mock.email(index)
});

// Définition d'un groupe avec des participants partagés
const createGroup = (index:any, participantSlice:any) => ({
  name: groupeName[index].name,
  id: _mock.id(index),
  participants: _Participants.slice(...participantSlice),
  createDate: _mock.time(index),
  description: `The Group focuses on technological innovation and finding innovative solutions in various fields. Our members are professionals passionate about technology and making positive changes in the world`
});

// Création des participants
export const _Participants = [...Array(12)].map((_, index) => createParticipant(index));

// Création des groupes
export const _groupeAgency = [
  [3, 9], [5, 12], [9, 18], [0, 9], [3, 10],[1, 13]
].map((participantSlice, index) => createGroup(index, participantSlice));
