import { add, subDays } from 'date-fns';

import { _mock } from './_mock';
import { _addressBooks } from './_others';
import { IPaymentMethod } from '@/shared/types/invoice';

// ----------------------------------------------------------------------

export const INVOICE_STATUS_OPTIONS = [
  { value: 'paid', label: 'Paid' },
  { value: 'pending', label: 'Pending' },
  { value: 'overdue', label: 'Overdue' },
  { value: 'draft', label: 'Draft' },
  { value: 'deleted', label: 'Deleted' },
];

export const INVOICE_SERVICE_OPTIONS = [...Array(8)].map((_, index) => ({
  id: _mock.id(index),
  name: _mock.role(index),
  price: _mock.number.price(index),
}));

export const INVOICE_PAYMENT_MODE_OPTIONS = [...Array(4)].map((_, index) => ({
  id: _mock.id(index),
  name: _mock.paymentMode(index),
  
}));



const ITEMS = [...Array(3)].map((__, index) => {
  const total = INVOICE_SERVICE_OPTIONS[index].price * _mock.number.nativeS(index);

  return {
    id: _mock.id(index),
    total,
    title: _mock.productName(index),
    description: _mock.sentence(index),
    price: INVOICE_SERVICE_OPTIONS[index].price,
    //service: INVOICE_SERVICE_OPTIONS[index].name,
    // devise:INVOICE_PAYMENT_MODE_OPTIONS[index].name,
    // paymentMode: INVOICE_PAYMENT_MODE_OPTIONS[index].name,
    quantity: _mock.number.nativeS(index),
  };
});

export const _invoices = [...Array(20)].map((_, index) => {
  const taxes = _mock.number.price(index + 1);
  
  const notes='';
  const signatureUrl='';
  const signatureUrlS3 = '';
  const subTotal = ITEMS.reduce((accumulator, item) => accumulator + item.price * item.quantity, 0);

  const totalAmount = subTotal + taxes;

  const paymentMode: IPaymentMethod = {
    id: _mock.id(index),
    name: (index % 2 && 'Credit Card') || (index % 3 && 'Bank Transfer') || 'Paypal'
  };

  const status =
    (index % 2 && 'paid') || (index % 3 && 'pending') || (index % 4 && 'overdue') ||(index % 5 && 'deleted') || 'draft';

  const devise =
    (index % 2 && 'DH') || (index % 3 && 'euro') || (index % 4 && 'dolar')  || 'franc';
  

  return {
    id: _mock.id(index),
    taxes,
    status,
    notes,
    paymentMode,
    devise,
    signatureUrl,
    signatureUrlS3,
    subTotal,
    totalAmount,
    productLine: ITEMS,
    invoiceNumber : `INV-199${index}`,
    // invoiceIssuer: _addressBooks[index],
    invoiceIssuer:2,
    // invoiceClient: _addressBooks[index + 1],
    invoiceClient :{
      id: 'client1',
      company: 'Company',
      emailAddress: 'email@example.com',
      phoneNumber: '1234567890',
      country: 'Country',
      city: 'City',
      street: 'Street',
      apartement: 'Apt',
      postalCode: '12345',
    },
    createDate: subDays(new Date(), index),
    dueDate: add(new Date(), { days: index + 15, hours: index }),
  };
});
