import Box from '@mui/material/Box';

import Scrollbar from '@/shared/components/scrollbar';
import Lightbox, { useLightBox } from '@/shared/components/lightbox';

import { IChatMessage, IChatParticipant, IClient } from '@/shared/types/chat';

import useMessagesScroll from '@/hooks/use-messages-scroll';
import ChatMessageItem from './chat-message-item';

// ----------------------------------------------------------------------

type Props = {
  messages: IChatMessage[];
  participants: IClient[];
};

export default function ChatMessageList({ messages = [], participants }: Props) {
  const { messagesEndRef } = useMessagesScroll(messages);
  const slides = messages
    .filter((message) => message.type === 'image')
    .map((message) => ({ src: message.body }));

  const lightbox = useLightBox(slides);

  return (
    <>
      <Scrollbar ref={messagesEndRef}
        sx={{
          height: 'calc(100vh - 200px)',
          '& .simplebar-content': {
            height: 'auto',
            display: 'flex',
            flexDirection: 'column',
          },
        }}

      >
        <Box>
          {messages.map((message) => (
            <ChatMessageItem
              key={message.id}
              message={message}
              participants={participants}
              onOpenLightbox={() => lightbox.onOpen(message.body)}
            />
          ))}
        </Box>
      </Scrollbar>

      <Lightbox
        index={lightbox.selected}
        slides={slides}
        open={lightbox.open}
        close={lightbox.onClose}
      />
    </>
  );
}
