'use client'

import { paths } from "@/routes/paths";
import { _agency } from "@/shared/_mock/_agency";
import {agency} from "@/shared/_mock/_agency1b";
import CustomBreadcrumbs from "@/shared/components/custom-breadcrumbs";
import { useSettingsContext } from "@/shared/components/settings";
import { Container } from "@mui/material";
import AgencyEditForm from "../agency-edit-form";

type Props = {
    id: string;
  };
  
  export default function AgencyceEditView({ id }: Props) {
    const settings = useSettingsContext();
  
    const currentAgency=agency;
  
    return (
      <Container maxWidth={settings.themeStretch ? false : 'lg'}>
        <CustomBreadcrumbs
          heading="Edit"
          links={[
            {
              name: 'Dashboard',
              href: paths.dashboard.root,
            },
            {
              name: 'Agency',
              href: paths.dashboard.agency.list,
            },
            
          ]}
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        />
  
        <AgencyEditForm currentAgency={currentAgency} />
      </Container>
    );
  }
  