import Box from '@mui/material/Box';
import Pagination, { paginationClasses } from '@mui/material/Pagination';
import { ProjectItemSkeleton } from './project-skeleton';
import PostItemHorizontal from './project-item-horizontal';
import { IProjectItem, Project } from '@/contexts/types/Project';

// ----------------------------------------------------------------------

type Props = {
  project: Project[];
  loading: boolean;
  onDeleteRow: (id: number) => void;
  onArchiveRow: (id: number) => void;
};

export default function ProjectListHorizontal({ project, loading, onDeleteRow, onArchiveRow }: Props) {
  const renderSkeleton = (
    <>
      {[...Array(16)].map((_, index) => (
        <ProjectItemSkeleton key={index} variant="horizontal" />
      ))}
    </>
  );

  const renderList = (
    <>
      {project.map((pro) => (
        <PostItemHorizontal key={pro.id} project={pro} onDeleteRow={onDeleteRow} onArchiveRow={onArchiveRow} />
      ))}
    </>
  );

  return (
    <>
      <Box
        gap={3}
        display="grid"
        gridTemplateColumns={{
          xs: 'repeat(1, 1fr)',
          md: 'repeat(2, 1fr)',
        }}
        style={{ marginTop: '20px' }}
      >
        {loading ? renderSkeleton : renderList}
      </Box>

      {project.length > 8 && (
        <Pagination
          count={8}
          sx={{
            mt: 8,
            [`& .${paginationClasses.ul}`]: {
              justifyContent: 'center',
            },
          }}
        />
      )}
    </>
  );
}
