import Box from "@mui/material/Box";
import Table from "@mui/material/Table";
import Tooltip from "@mui/material/Tooltip";
import { useTheme } from "@mui/material/styles";
import TableBody from "@mui/material/TableBody";
import IconButton from "@mui/material/IconButton";
import TableContainer from "@mui/material/TableContainer";
import { tableCellClasses } from "@mui/material/TableCell";
import { tablePaginationClasses } from "@mui/material/TablePagination";

import Iconify from "@/shared/components/iconify";
import { TableProps, TableSelectedAction } from "@/components/table/index";
import { TableNoData } from "@/components/table/index";
import { TableHeadCustom } from "@/components/table/index";
import { TablePaginationCustom } from "@/components/table/index";
import { IProjectItem, Project } from "@/contexts/types/Project";

import ProjectArchivedTableRow from "./projects-favoris-table-row";
import { ConfirmDialog } from "@/components/custom-dialog";
import { Button } from "@mui/material";
import { useBoolean } from "@/hooks";
import ProjectDeletedTableRow from "./projects-deleted-table-row";

// ----------------------------------------------------------------------

const TABLE_HEAD = [
  { id: "name", label: "Name" },
  { id: "DeletedAt", label: "Deleted At", width: 120 },
  { id: "type", label: "Type", width: 120 },
  { id: "Satuts", label: "Status", width: 120 },
  { id: "EndDate", label: "End Date", width: 140 },
  { id: "StartDate", label: "Start Date", width: 140 },
  { id: "Participants", label: "Participants", align: "right", width: 140 },
];

// ----------------------------------------------------------------------

type Props = {
  table: TableProps;
  notFound: boolean;
  dataFiltered: Project[];
};

export default function ProjectDeletedTable({
  table,
  notFound,
  dataFiltered,
}: Props) {
  const theme = useTheme();

  const {
    dense,
    page,
    order,
    orderBy,
    rowsPerPage,
    //
    selected,
    onSelectRow,
    onSelectAllRows,
    //
    onSort,
    onChangeDense,
    onChangePage,
    onChangeRowsPerPage,
  } = table;
  const confirmFavorite = useBoolean();
  return (
    <>
      <Box
        sx={{
          position: "relative",
          m: theme.spacing(-2, -3, -3, -3),
        }}
      >
        <TableContainer
          sx={{
            p: theme.spacing(0, 3, 3, 3),
          }}
        >
          <Table
            size={dense ? "small" : "medium"}
            sx={{
              minWidth: 960,
              borderCollapse: "separate",
              borderSpacing: "0 16px",
            }}
          >
            <TableHeadCustom
              order={order}
              orderBy={orderBy}
              headLabel={TABLE_HEAD}
              rowCount={dataFiltered.length}
              numSelected={selected.length}
              onSort={onSort}
              sx={{
                [`& .${tableCellClasses.head}`]: {
                  "&:first-of-type": {
                    borderTopLeftRadius: 12,
                    borderBottomLeftRadius: 12,
                  },
                  "&:last-of-type": {
                    borderTopRightRadius: 12,
                    borderBottomRightRadius: 12,
                  },
                },
              }}
            />

            <TableBody>
              {dataFiltered
                .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                .map((row) => (
                  <>
                    <ProjectDeletedTableRow key={row.id} row={row} />
                  </>
                ))}

              <TableNoData
                notFound={notFound}
                sx={{
                  m: -2,
                  borderRadius: 1.5,
                  border: `dashed 1px ${theme.palette.divider}`,
                }}
              />
            </TableBody>
          </Table>
        </TableContainer>
      </Box>

      <TablePaginationCustom
        count={dataFiltered.length}
        page={page}
        rowsPerPage={rowsPerPage}
        onPageChange={onChangePage}
        onRowsPerPageChange={onChangeRowsPerPage}
        dense={dense}
        onChangeDense={onChangeDense}
        sx={{
          [`& .${tablePaginationClasses.toolbar}`]: {
            borderTopColor: "transparent",
          },
        }}
      />
    </>
  );
}
