import Chart, { useChart } from '@/shared/components/chart';
import { color } from 'framer-motion';

// ----------------------------------------------------------------------

type Props = {
  series: {
    name: string;
    data: number[],
    color: string,
    axis: string[],
  }[];
};

export default function ChartArea({ series }: Props) {
  const chartOptions = useChart({
    xaxis: {
      categories: series[0].axis,
    },
    tooltip: {
      x: {
        show: false,
      },
      marker: { show: false },
    },
  
  });

  return (
    <Chart dir="ltr" type="area" series={series} options={chartOptions} width="100%" height={320} color={color}/>
  );
}
