'use client'
import Timeline from '@mui/lab/Timeline';
import TimelineDot from '@mui/lab/TimelineDot';
import Typography from '@mui/material/Typography';
import TimelineContent from '@mui/lab/TimelineContent';
import TimelineSeparator from '@mui/lab/TimelineSeparator';
import TimelineConnector from '@mui/lab/TimelineConnector';
import TimelineItem, { timelineItemClasses } from '@mui/lab/TimelineItem';
// ----------------------------------------------------------------------
type Props = {
    caractrs: string[];
}
export default function CaracterStunar({caractrs} : Props) {
  return (
<>
      <Timeline
        sx={{
          m: 0,
          p: 3,
          [`& .${timelineItemClasses.root}:before`]: {
            flex: 0,
            padding: 0,
          },
        }}
      >
        {caractrs.map((item, index) => (
          <OrderItem key={index} item={item} lastTimeline={index === caractrs.length - 1} />
        ))}
       
      </Timeline>
    
  </>
  );
}

// ----------------------------------------------------------------------

type OrderItemProps = {
  item: string;
  lastTimeline: boolean;
  
};
////

function OrderItem({ item, lastTimeline }: OrderItemProps) {
  return (
    <TimelineItem>
      <TimelineSeparator>
        <TimelineDot
          color={
            'warning'
          }
        />
        {lastTimeline ? null : <TimelineConnector />}
      </TimelineSeparator>

      <TimelineContent>
        <Typography variant="subtitle2">{item}</Typography>
      </TimelineContent>
   </TimelineItem>
  );
}
