'use client'
import { IRewardItem } from "@/contexts/types/reward";
import Grid from '@mui/material/Unstable_Grid2';
import RewardDetailsContent from "./reward-details";
import { Container } from "postcss";
import { paths } from "@/routes/paths";
import CustomBreadcrumbs from "@/components/custom-breadcrumbs";
import { useCallback, useState } from "react";
import TasksMarks from "./tasks-marks";
import { useBoolean } from "@/hooks";
import Iconify from "@/shared/components/iconify";
import { Tab, Tabs } from "@mui/material";
import RewardAnalyticView from "../statistics/analytic-reward-view";
import { Typography } from "@mui/material";

type Props = {
  reward: IRewardItem;
};

export default function RewardView({ reward }: Props) {
  const [currentTab, setCurrentTab] = useState('details');
  const [approved, setApproved] = useState<string[]>(["Published"]);

  const handleClick = useCallback(
    (item: string) => {
      const selected = approved.includes(item)
        ? approved.filter((value) => value !== item)
        : [...approved, item];

      setApproved(selected);
    },
    [approved]
  );

  const handleChangeTab = useCallback((event: React.SyntheticEvent, newValue: string) => {
    setCurrentTab(newValue);
  }, []);

  const TABS = [
    {
      value: 'details',
      label: 'Details',
      icon: <Iconify icon="arcticons:rewards" width={24} />,
    },
    {
      value: 'statistics',
      label: 'Statistics',
      icon: <Iconify icon="carbon:analytics" width={24} />,
    }
  ];

  return (
    <>
      <CustomBreadcrumbs
        heading="Reward Details"
        links={[
          {
            name: 'Dashboard',
            href: paths.dashboard.root,
          },
          {
            name: 'Rewards',
            href: paths.dashboard.rewards.all_rewards,
          },
          {
            name: ' Reward Details',
          },
        ]}
        sx={{
          mb: { xs: 3, md: 5 }, ml: 3
        }}
      />
      <Tabs
        value={currentTab}
        onChange={handleChangeTab}
        sx={{
          mb: { xs: 2, md: 3 }, ml: { xs: 3, md: 5 }
        }}
      >
        {TABS.map((tab) => (
          <Tab key={tab.value} label={tab.label} icon={tab.icon} value={tab.value} />
        ))}
      </Tabs>

      <Grid container spacing={1} disableEqualOverflow sx={{ ml: 3 }}>
        {currentTab === 'details' && (
          <>
            {!reward ? (
              <Grid xs={12}>
                <Typography variant="body1">No reward data available</Typography>
              </Grid>
            ) : (
              <>
                <Grid xs={12} md={8}>
                  <RewardDetailsContent 
                    reward={reward} 
                    selected={approved.includes(reward.status)} 
                    onSelected={() => handleClick(reward.status)} 
                  />
                </Grid>
                <Grid xs={12} md={4}>
                  <TasksMarks rewardId={Number(reward.id)} />
                </Grid>
              </>
            )}
          </>
        )}
        {currentTab === 'statistics' && (
          !reward ? (
            <Grid xs={12}>
              <Typography variant="body1">No statistics data available</Typography>
            </Grid>
          ) : (
            <RewardAnalyticView rewardId={Number(reward.id)} />
          )
        )}
      </Grid>
    </>
  );
}