import { ITransferTableFilterValue, ITransferTableFilters } from "@/shared/types/transfer";
import { Box, Chip, Paper, Stack, StackProps } from "@mui/material";
import { useCallback } from "react";

type Props = StackProps & {
    filters: ITransferTableFilters;
    onFilters: (title: string, value: ITransferTableFilterValue) => void;
    onResetFilters: VoidFunction;
    results: number;
};

export default function TransferTableFiltresResult({
    filters,
    onFilters,
    onResetFilters,
    results,
    ...other
}: Props) {
    const handleRemoveKeyword = useCallback(() => {
        onFilters('title', '');
    }, [onFilters]);

    return (
        <Stack spacing={1.5} {...other}>
            <Box sx={{ typography: 'body2' }}>
                <strong>{results}</strong>
                <Box component="span" sx={{ color: 'text.secondary', ml: 0.25 }}>
                    results found
                </Box>
            </Box>

            <Stack flexGrow={1} spacing={1} direction="row" flexWrap="wrap" alignItems="center">
                {!!filters.title && (
                    <Block label="Keyword:">
                        <Chip 
                            size="small" 
                            label={filters.title} 
                            onDelete={handleRemoveKeyword}
                        />
                    </Block>
                )}
            </Stack>
        </Stack>
    );
}

type BlockProps = StackProps & {
    label: string;
};

function Block({ label, children, sx, ...other }: BlockProps) {
    return (
        <Stack
            component={Paper}
            variant="outlined"
            spacing={1}
            direction="row"
            sx={{
                p: 1,
                borderRadius: 1,
                overflow: 'hidden',
                borderStyle: 'dashed',
                ...sx,
            }}
            {...other}
        >
            <Box component="span" sx={{ typography: 'subtitle2' }}>
                {label}
            </Box>

            <Stack spacing={1} direction="row" flexWrap="wrap">
                {children}
            </Stack>
        </Stack>
    );
}