import Button from '@mui/material/Button';
import Dialog from '@mui/material/Dialog';
import DialogActions from '@mui/material/DialogActions';
import DialogContent from '@mui/material/DialogContent';
import DialogContentText from '@mui/material/DialogContentText';
import DialogTitle from '@mui/material/DialogTitle';

type ConfirmDialogDeleteUserProps = {
  open: boolean;
  onClose: () => void;
  title: string;
  content: string;
  action: React.ReactNode;
};

export default function ConfirmDialogDeleteUser({
  open,
  onClose,
  title,
  content,
  action,
}: ConfirmDialogDeleteUserProps) {
  return (
    <Dialog
      open={open}
      onClose={onClose}
      aria-labelledby="alert-dialog-title"
      aria-describedby="alert-dialog-description"
    >
      <DialogTitle id="alert-dialog-title">{title}</DialogTitle>
      <DialogContent>
        <DialogContentText id="alert-dialog-description">{content}</DialogContentText>
      </DialogContent>
      <DialogActions>
        <Button onClick={onClose} color="primary">
          Cancel
        </Button>
        {action} {/* Render the action button */}
      </DialogActions>
    </Dialog>
  );
}