'use client'
import CustomBreadcrumbs from "@/components/custom-breadcrumbs";
import { paths } from "@/routes/paths";
import { _agency } from "@/shared/_mock/_agency";
import Iconify from "@/shared/components/iconify";
import { useSettingsContext } from "@/shared/components/settings";
import { Container, Tab, Tabs } from "@mui/material";
import { useCallback, useState } from "react";
import UserEditView from "./user-edit-view";
import UpdatePassword from "./update-password";
type Props = {
    id : string;
}
export default function ProfileView({id} :Props)
{
    const settings = useSettingsContext();
    const currentAgency = _agency.filter((agency) => agency.id === id)[0];
     let name: string  = currentAgency.name;
    //tab current
    const [currentTab, setCurrentTab] = useState('profile');
    //l'ensemble de tab

    const TABS = [
        {
          value: 'profile',
          label: 'Profile',
          icon: <Iconify icon="solar:user-id-bold" width={24} />,
        },
        {
          value: 'password',
          label: 'Password',
          icon:<Iconify icon="ic:round-vpn-key" width={24} />
        },
        
       
      ];
//si tab change
const handleChangeTab = useCallback((event: React.SyntheticEvent, newValue: string) => {
    setCurrentTab(newValue);
  }, []);
return (

    <Container maxWidth={settings.themeStretch ? false : 'lg'}>
      <CustomBreadcrumbs
        heading='Details'
        links={[
          { name: 'Dashboard', href: paths.dashboard.root },
        ]}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      />

      <Tabs
        value={currentTab}
        onChange={handleChangeTab}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      >
        {TABS.map((tab) => (
          <Tab key={tab.value} label={tab.label} icon={tab.icon} value={tab.value} />
        ))}
      </Tabs>

      {currentTab === 'profile' && (<UserEditView id={id} />)}

      {currentTab === 'password' && (<UpdatePassword></UpdatePassword>)}


     
    </Container>
)

}