// ----------------------------------------------------------------------

import { AccessLevel } from "../api/file-manager";

export type IFileFilterValue = string | string[] | Date | null;

export type IFileFilters = {
  name: string;
  type: string[];
  startDate: Date | null;
  endDate: Date | null;
};

// ----------------------------------------------------------------------

export type IFileShared = {
  id: string;
  name: string;
  email: string;
  avatarUrl: string;
  permission: string;
};

export interface SourceDocument {
  path?: string | null;
  type: string;
  name: string;
  url?: string | null;
}

export interface DestinationFolder {
  path: string;
  name: string;
}

export type IBaseFile = {
  id: string;
  name: string;
  size: number | null;
  type: string;
  url?: string;
  tags?: string[];
  isFavorited: boolean;
  shared: IFileShared[] | null;
  createdAt: string | null;
  modifiedAt: string;
  visibility: string;
  permissions: AccessLevel;
  path: string ;
  ownerFullName?: string;
  userOwner:number;
  uniqueId: string;
  agency: number;
  childrenFiles?: IFileManager[];
  childrenFolders?: IFolderManager[];
  parentFolder: number | null;
};

export type IFolderManager = IBaseFile & {
  totalFiles?: number;
};

export type IFileManager = IBaseFile;

export type IPdf = {
  name: string;
  url: string |undefined ;
};

export type IFile = IFileManager | IFolderManager;