import { IAddressItem } from './address';

// ----------------------------------------------------------------------

export type IInvoiceTableFilterValue = string | string[] | Date | null;

export type IInvoiceTableFilters = {
  name: string;
  paymentMode: string[];
  status: string;
  startDate: Date | null;
  endDate: Date | null;
};

// ----------------------------------------------------------------------

export type IInvoiceItem = {
  id: string;
  title: string;
  price: number;
  total: number;
  quantity: number;
  description: string;
};

export type IInvoice = {
  id: string;
  paymentMode:IPaymentMethod;
  signatureUrl?: string | null;
  signatureUrlS3?:string | null;
  notes?:string;
  devise?:string
  dueDate: Date;
  taxes: number;
  status: string;
  subTotal: number;
  createDate: Date;
  totalAmount: number;
  invoiceNumber: string;
  productLine: IInvoiceItem[];
  invoiceClient: IInvoiceClient;
  invoiceIssuer: number;
  responsibleId?: number;
  agencyId?: number;
};

export type IPaymentMethod ={
  id?: string;
  name :string;
};

export type IProduct ={
  id?: string;
  name :string;
  agencyId?:number;
};

export type IInvoiceClient = {
  id?: string;
  company?: string;
  name?:string;
  emailAddress?: string;
  phoneNumber?: string;
  country?: string;
  city?: string;
  street?: string;
  apartement?: string;
  postalCode?: string;
};
export type IInvoiceManager ={
  id?: string;
  firstName?:string;
  lastName?:string;
  email?:string;
  phoneNumber?:string;
};

export interface GroupWithAddress {
  id?: number;
  name?: string;
  description?: string;
  agencyId?: number;
  primaryAddress?: string;
  optionalAddress?: string | null;
  postalCode?: string;
  city?: string;
  country?: string;
}



