import { CustomFile } from '@/shared/components/upload';
import { IAgency } from './agency';

// ----------------------------------------------------------------------

export type IUserTableFilterValue = string | string[];

export type IUserTableFilters = {
  name: string;
  role: string[];
  status: string;
};

// ----------------------------------------------------------------------

export type IUserSocialLink = {
  facebook: string;
  instagram: string;
  linkedin: string;
  twitter: string;
};

export type IUserProfileCover = {
  name: string;
  role: string;
  coverUrl: string;
  avatarUrl: string;
};

export type IUserProfile = {
  id: string;
  role: string;
  quote: string;
  email: string;
  school: string;
  country: string;
  company: string;
  totalFollowers: number;
  totalFollowing: number;
  socialLinks: IUserSocialLink;
};
export interface AuthenticationRequest {
  username: string;
  password: string;
}

export type IUserProfileFollower = {
  id: string;
  name: string;
  country: string;
  avatarUrl: string;
};

export type IUserProfileGallery = {
  id: string;
  title: string;
  imageUrl: string;
  postedAt: Date;
};

export type IUserProfileFriend = {
  id: string;
  name: string;
  role: string;
  avatarUrl: string;
};

export type IUserProfilePost = {
  id: string;
  media: string;
  message: string;
  createdAt: Date;
  personLikes: {
    name: string;
    avatarUrl: string;
  }[];
  comments: {
    id: string;
    message: string;
    createdAt: Date;
    author: {
      id: string;
      name: string;
      avatarUrl: string;
    };
  }[];
};

export type IUserCard = {
  id: string;
  name: string;
  role: string;
  coverUrl: string;
  avatarUrl: string;
  totalPosts: number;
  totalFollowers: number;
  totalFollowing: number;
};

export type IUserItem = {
  id: string;
  firstName: string;
  lastName: string;
  city: string;
  role: string;
  email: string;
  state: string;
  status: string;
  country: string;
  zipCode: string;
  company: string;
  avatarUrl: string;
  agency: string;
  phoneNumber: string;
  isVerified: boolean;
  streetName: string;
  streetNumber: string;
};

export type IUserAccount = {
  email: string;
  isPublic: boolean;
  displayName: string;
  city: string | null;
  state: string | null;
  about: string | null;
  country: string | null;
  address: string | null;
  zipCode: string | null;
  phoneNumber: string | null;
  photoURL: CustomFile | string | null;
};

export type IUserAccountBillingHistory = {
  id: string;
  price: number;
  createdAt: Date;
  invoiceNumber: string;
};

export type IUserAccountChangePassword = {
  oldPassword: string;
  newPassword: string;
  confirmNewPassword: string;
};
export interface AuthenticationRequest {
  username: string;
  password: string;
}
export type IUser = {
  id: string;
  email: string;
  pseudo: string;
  uid: number;
  password?: string;
  phoneNumber: string;
  firstName: string;
  lastName: string;
  imageUrl?: string ; 
  status: string;
  agency?: IAgency;
  activityLog: boolean;
  address?: any;
  group?: any;
  role?: string;
};


export interface TokenPayload {
  exp: number;
  iat: number;
  name: string;
  email: string;
  userId: string;
  realm_access: {
    roles: string[];
  };
  agency_role: { [key: string]: string };
  isValid: Boolean;
}
export type RequestLoginActivity = {
  email: string;
  activityLog: Boolean;
};
