export function getFileThumb(fileType: string) {
    if (fileType === 'folder') {
      return 'material-symbols:folder';
    }
  
    const extension = fileType.toLowerCase();
  
    if (['jpg', 'jpeg', 'png', 'gif'].includes(extension)) {
      return 'material-symbols:image';
    }
  
    if (['mp4', 'avi', 'mov', 'wmv'].includes(extension)) {
      return 'material-symbols:video-file';
    }
  
    if (['mp3', 'wav', 'ogg'].includes(extension)) {
      return 'material-symbols:audio-file';
    }
  
    if (['doc', 'docx'].includes(extension)) {
      return 'material-symbols:description';
    }
  
    if (['xls', 'xlsx'].includes(extension)) {
      return 'material-symbols:spreadsheet';
    }
  
    if (['ppt', 'pptx'].includes(extension)) {
      return 'material-symbols:presentation';
    }
  
    if (extension === 'pdf') {
      return 'material-symbols:pdf';
    }
  
    if (['zip', 'rar', '7z'].includes(extension)) {
      return 'material-symbols:folder-zip';
    }
  
    if (['txt', 'rtf'].includes(extension)) {
      return 'material-symbols:text-snippet';
    }
  
    // Pour les autres types de fichiers
    return 'material-symbols:file-present';
  }
  
  // Fonction utilitaire pour obtenir l'extension du fichier
  export function getFileFormat(fileName: string) {
    if (!fileName) return '';
    
    const extension = fileName.split('.').pop()?.toLowerCase() || '';
    
    if (extension === 'folder') return 'Folder';
    
    const formats: { [key: string]: string } = {
      // Images
      jpg: 'Image',
      jpeg: 'Image',
      png: 'Image',
      gif: 'Image',
      
      // Documents
      pdf: 'PDF',
      doc: 'Word',
      docx: 'Word',
      xls: 'Excel',
      xlsx: 'Excel',
      ppt: 'PowerPoint',
      pptx: 'PowerPoint',
      
      // Audio
      mp3: 'Audio',
      wav: 'Audio',
      ogg: 'Audio',
      
      // Video
      mp4: 'Video',
      avi: 'Video',
      mov: 'Video',
      wmv: 'Video',
      
      // Archives
      zip: 'Archive',
      rar: 'Archive',
      '7z': 'Archive',
      
      // Text
      txt: 'Text',
      rtf: 'Text',
    };
    
    return formats[extension] || 'Other';
  }
  