import { paths } from "@/routes/paths";

// API
// ----------------------------------------------------------------------
export const HOST_API = process.env.NEXT_PUBLIC_HOST_API;
export const PROJECT_API = process.env.NEXT_PUBLIC_GATEWAY_API;
export const INVOICE_API = process.env.NEXT_PUBLIC_INVOICE_API;
export const CALENDAR_API = process.env.NEXT_PUBLIC_CALENDAR_API;
export const USER_API = process.env.NEXT_PUBLIC_USER_API;
export const GATEWAY = process.env.NEXT_PUBLIC_GATEWAY_API;
export const ASSETS_API = process.env.NEXT_PUBLIC_ASSETS_API;
export const COLLABORATOR_API =
  process.env.NEXT_PUBLIC_BACKEND_USERSERVICE_COLLABRATOR_API;
// GATEWAY API
export const FIREBASE_API = {
  apiKey: process.env.NEXT_PUBLIC_FIREBASE_API_KEY,
  authDomain: process.env.NEXT_PUBLIC_FIREBASE_AUTH_DOMAIN,
  projectId: process.env.NEXT_PUBLIC_FIREBASE_PROJECT_ID,
  storageBucket: process.env.NEXT_PUBLIC_FIREBASE_STORAGE_BUCKET,
  messagingSenderId: process.env.NEXT_PUBLIC_FIREBASE_MESSAGING_SENDER_ID,
  appId: process.env.NEXT_PUBLIC_FIREBASE_APPID,
  measurementId: process.env.NEXT_PUBLIC_FIREBASE_MEASUREMENT_ID,
  vapiKey: process.env.NEXT_PUBLIC_FIREBASE_V_API_KEY,
};

export const AMPLIFY_API = {
  userPoolId: process.env.NEXT_PUBLIC_AWS_AMPLIFY_USER_POOL_ID,
  userPoolWebClientId:
    process.env.NEXT_PUBLIC_AWS_AMPLIFY_USER_POOL_WEB_CLIENT_ID,
  region: process.env.NEXT_PUBLIC_AWS_AMPLIFY_REGION,
};

export const AUTH0_API = {
  clientId: process.env.NEXT_PUBLIC_AUTH0_CLIENT_ID,
  domain: process.env.NEXT_PUBLIC_AUTH0_DOMAIN,
  callbackUrl: process.env.NEXT_PUBLIC_AUTH0_CALLBACK_URL,
};

export const SUPABASE_API = {
  url: process.env.NEXT_PUBLIC_SUPABASE_URL,
  key: process.env.NEXT_PUBLIC_SUPABASE_ANON_KEY,
};

export const MAPBOX_API = process.env.NEXT_PUBLIC_MAPBOX_API;

// ROOT PATH AFTER LOGIN SUCCESSFUL
export const PATH_AFTER_LOGIN = paths.dashboard.root; // as '/dashboard'
