import { usePathname } from 'next/navigation';

// ----------------------------------------------------------------------



export function useActiveLink(path: string, deep = true): boolean {
  
  if (typeof path !== 'string') {
    console.log("path is : ",path);
    console.error('path must be a string');
    return false;
  }
  const pathname = usePathname();

  const checkPath = path.startsWith('#');


  const currentPath = path === '/' ? '/' : `${path}/`;


  const normalActive = !checkPath && pathname === currentPath;

  const deepActive = !checkPath && pathname.includes(currentPath);

  return deep ? deepActive : normalActive;
}
