import { useState, useCallback } from 'react';

export function usePopover() {
  const [open, setOpen] = useState(false);
  const [anchorEl, setAnchorEl] = useState<null | HTMLElement>(null);

  const onOpen = useCallback((event: React.MouseEvent<HTMLElement>) => {
    setAnchorEl(event.currentTarget);
    setOpen(true);
  }, []);

  const onClose = useCallback(() => {
    setAnchorEl(null);
    setOpen(false);
  }, []);

  return {
    open,
    anchorEl,
    onOpen,
    onClose,
  };
} 