'use client';

import Container from '@mui/material/Container';

import { paths } from '@/routes/paths';

import { _project } from '@/shared/_mock/_projects';

import { useSettingsContext } from '@/shared/components/settings';
import CustomBreadcrumbs from '@/components/custom-breadcrumbs';

import ProjectNewEditForm from './project-new-edit-form';
import { useGetProject, useGetProjects } from '@/shared/api/project';
import { Console } from 'console';
import { LoadingScreen } from '@/shared/components/loading-screen';

// ----------------------------------------------------------------------

type Props = {
  id: number;
};

export default function ProjectEditView({ id }: Props) {
  const settings = useSettingsContext();
  const { ProjectData, projectIsLoading } =useGetProject(id);
  if (!ProjectData) {
    return <LoadingScreen />;
  }

  return (
    <Container maxWidth={settings.themeStretch ? false : 'lg'}>
      <CustomBreadcrumbs
        heading="Edit"
        links={[
          {
            name: 'Dashboard',
            href: paths.dashboard.root,
          },
          {
            name: 'Projects',
            href: paths.dashboard.projects.all_projects,
          },
          { name: ProjectData?.name },
        ]}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      />

      <ProjectNewEditForm currentProject={ProjectData} />
    </Container>
  );
}
