import Iconify from "@/shared/components/iconify/iconify";
import { IAgencyTableFilters, IAgencyTableFilterValue } from "@/shared/types/agency";
import InputAdornment from "@mui/material/InputAdornment";
import Stack from "@mui/material/Stack";
import TextField from "@mui/material/TextField";
import { useCallback } from "react";
import { SxProps } from '@mui/material';

// on definit it props avec la précision des types de propreties de props
interface Props {
    filters: IAgencyTableFilters;
    onFilters: (name: string, value: IAgencyTableFilterValue) => void;
    sx?: SxProps;
}

export default function AgencyTableToolbar({
        filters,
        onFilters,
        sx
    }: Props)

{

const handleFilterName = useCallback(
    (event: React.ChangeEvent<HTMLInputElement>) => {
      onFilters('name', event.target.value);
    },
    [onFilters]
  );
//

  //
  return (
    <>
    <Stack
          spacing={2}
          alignItems={{ xs: 'flex-end', md: 'center' }}
          direction={{
            xs: 'column',
            md: 'row',
          }}
          sx={sx}
        >
         <Stack direction="row" alignItems="center" spacing={2} flexGrow={1} sx={{ width: 1 }}>
            <TextField
              fullWidth
              value={filters.name}
              onChange={handleFilterName}
              placeholder="Search name agency..."
              InputProps={{
                startAdornment: (
                  <InputAdornment position="start">
                    <Iconify icon="eva:search-fill" sx={{ color: 'text.disabled' }} />
                  </InputAdornment>
                ),
              }}
              sx={{
                width: { xs: 1, md: 260 },
              }}
            />
            
        </Stack>
        </Stack>
    </>
  )
}