import Chart, { useChart } from '@/shared/components/chart';
import { useTheme } from '@mui/material/styles';
import Box from '@mui/material/Box';
import Typography from '@mui/material/Typography';
import { styles, getChartOptions } from '../../styles/chart-horizontal-bar.styles';

// Types
type SeriesItem = {
  name: string;
  data: number[];
  axis: string[];
  color: string;
};

type ChartOptions = {
  colors?: string[];
  tooltip?: {
    y?: {
      formatter?: (val: number, opts: { dataPointIndex: number; seriesIndex: number }) => string;
    };
    x?: {
      formatter?: (val: number) => string;
    };
  };
  [key: string]: any;
};

type Props = {
  series: SeriesItem[];
  options?: ChartOptions;
  height?: number;
};

export default function ChartHorizontalBar({ series, options = {}, height = 320 }: Props) {
  const theme = useTheme();
  
  if (!series.length || !series[0].data.length) {
    return (
      <Box sx={styles.emptyDataContainer}>
        <Typography variant="body2" color="text.secondary">
          No project data available
        </Typography>
      </Box>
    );
  }

  const itemCount = series[0].axis.length;
  const dynamicHeight = Math.max(height, itemCount * 30);

  const chartOptions = useChart(getChartOptions(theme, series, options));

  const transformedSeries = [{
    name: series[0].name,
    data: series[0].data,
  }];

  return (
    <Box sx={styles.chartContainer(dynamicHeight)}>
      <Chart 
        dir="ltr" 
        type="bar" 
        series={transformedSeries} 
        options={chartOptions} 
        width="100%" 
        height={dynamicHeight} 
      />
    </Box>
  );
} 