import Iconify from "@/shared/components/iconify";
import { Box, Button, Checkbox, Dialog, DialogActions, DialogContent, DialogProps, DialogTitle, Divider, FormGroup, InputAdornment, Stack, Switch, TextField, Typography } from "@mui/material";
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import FormLabel from '@mui/material/FormLabel';
import { useCallback, useState } from "react";
import ChatHeaderCompose from "./chat-header-compose";
import { IChatParticipant } from "@/shared/types/chat";
import { alpha } from '@mui/material/styles';
import { useGetContacts } from "@/shared/api/chat";
import ChatChannels from "./chat-channels";
type Props = DialogProps & {
    //
    open: boolean;
    onClose: VoidFunction;
  };
interface CheckedStates {
[key: string]: boolean;
}
export default function ChatManageAnonymity({open,
    onClose,...other}:Props){
    
    const [directvalue, setDirectvalue] = useState('all');

    const [teamValue, setTeamValue] = useState('all');

    const [clientValue, setClientValue] = useState('all');

    const [channelName, setChannelName] = useState('');

    const isChannelNameEmpty = channelName.trim() === '';

    const { contacts } = useGetContacts();

    const [recipients, setRecipients] = useState<IChatParticipant[]>([]);

    const handleChannelNameChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setChannelName(event.target.value);
    };

    const handleAddRecipients = useCallback((selected: IChatParticipant[]) => {
        setRecipients(selected);
      }, []);

    const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setDirectvalue((event.target as HTMLInputElement).value);
    };

    const handleTeamChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setTeamValue((event.target as HTMLInputElement).value);
    };

    const handleClientChange = (event: React.ChangeEvent<HTMLInputElement>) => {
        setClientValue((event.target as HTMLInputElement).value);
    };

    const [allNotifschecked, setAllNotifsChecked] = useState(false);

    const handleChangeNotifsAllNotifs = (event: React.ChangeEvent<HTMLInputElement>) => {
        setAllNotifsChecked(event.target.checked);
    };

    const [categNotifschecked, setCategNotifsChecked] = useState<CheckedStates>({ Direct: false, Channel: false});

    const handleChangeNotifsByCateg = (event: React.ChangeEvent<HTMLInputElement>) => {
        const { name, checked } = event.target;
        if (name in categNotifschecked) {
            setCategNotifsChecked(prev => ({ ...prev, [name]: checked }));
        }
      };
    return (
        <Dialog fullWidth maxWidth="xs" open={open} onClose={onClose} sx={{ overflow: 'hidden' }}>
        <DialogTitle >Manage anonymity </DialogTitle>

        <DialogContent sx={{ overflow: 'unset' }}>
            
            <FormControl>
                <FormGroup aria-label="position" row>
                    
                    <FormControlLabel
                    value="allNotifications"
                    control={<Switch
                        checked={allNotifschecked}
                        onChange={handleChangeNotifsAllNotifs}
                        name="allNotifschecked"
                    />}
                    label="All client discussions"
                    labelPlacement="end"
                    
                    />
                    {allNotifschecked ? 
                        <Typography variant="caption" sx={{color:(theme) => theme.palette.error.main,}}>
                            All client discussions will be anonym !
                        </Typography>:
                        (<Stack direction='column' alignItems="flex-start" justifyContent='space-between' sx={{width:1,mb:3}}>
                        <Divider orientation="horizontal" flexItem sx={{ my: 3 }} />
                        <Typography variant="body2" sx={{ color: 'text.primary', mr: 2,mb:2 }}>
                                Activate anonymity for  :
                        </Typography>
                        <ChatChannels />
                            
                    </Stack>)
                    }
                    
                </FormGroup> 
            </FormControl>           

        </DialogContent>

        <DialogActions sx={{ justifyContent: 'end' }}>
            <Button
                color="inherit"
                variant="contained"
            >
                Save changes
            </Button>
            <Button variant="outlined" color="inherit" onClick={onClose}>
                Close
            </Button>

        </DialogActions>
        </Dialog>
    );
}