import { ApexOptions } from 'apexcharts';
import Box from '@mui/material/Box';
import { CardProps } from '@mui/material/Card';
import Chart, { useChart } from '@/shared/components/chart';

// ----------------------------------------------------------------------

interface Props extends CardProps {
  title?: string;
  subheader?: string;
  chart: {
    axis: string[];
    colors?: string[];
    series: {
        name: string;
        data: number[];  
    }[];
    options?: ApexOptions;
  };
  searchValue: string;
}

export default function TasksByStatus({ title, subheader, chart,searchValue, ...other }: Props) {
  const { axis, colors, series, options } = chart;
  if (searchValue.trim() === "") {
  const chartOptions = useChart({
    chart: {
      stacked: true,
    },
    colors,
    stroke: {
      width: 0,
    },
    xaxis: {
      categories: axis 
    },
   
    plotOptions: {
      bar: {
        borderRadius:6,
        columnWidth: '20%',
      },
    },
    ...options,
  });
  return (
    <>
      <Box sx={{ mt: 3, mx: 3 }}>
           
              <Chart
                dir="ltr"
                type="bar"
                series={series}
                options={chartOptions}
                width="100%"
                height={364}
              />
           
          </Box>   
    </>
  );}
  const filteredSeries = series.map((item) => {
    const filteredData = item.data.filter((dataItem, index) =>
      axis[index].toLowerCase().includes(searchValue.toLowerCase())
    );
    return {
      ...item,
      data: filteredData,
    };
  });
  const filteredAxis = axis.filter((axisItem, index) =>
    axisItem.toLowerCase().includes(searchValue.toLowerCase()) 
  );
  const chartOptions = useChart({
    chart: {
      stacked: true,
    },
    colors,
    stroke: {
      width: 0,
    },
    xaxis: {
      categories: filteredAxis 
    },
   
    plotOptions: {
      bar: {
        borderRadius:6,
        columnWidth: '20%',
      },
    },
    ...options,
  });
  return (
    <>
       <Box sx={{ mt: 3, mx: 3 }}>
           
              <Chart
                dir="ltr"
                type="bar"
                series={filteredSeries}
                options={chartOptions}
                width="100%"
                height={364}
              />    
          </Box>
    </>
  );
}
