import AdminApplicationDashboard from '@/shared/sections/home/admin-dash';
import EmployeDashboard from '@/shared/sections/home/employee-dash';
import ResponsableAgenceDashboard from '@/shared/sections/home/manager-dash';
import ClientDashbord from '@/shared/sections/home/client-dash';

export default function Home() {
  // Get the role from localStorage
  const storedRoles = localStorage.getItem('role');
  let roles = [];

  if (storedRoles) {
    try {
      // Parse roles as array or handle single role as string
      roles = JSON.parse(storedRoles);
    } catch (error) {
      console.error('Error parsing roles:', error);
    }
  } else {
    console.log('No roles found in localStorage');
  }

  // Check for roles and return the corresponding dashboard
  if (roles.includes("ADMIN")) {
    
    return <AdminApplicationDashboard />;
  } else if (roles.includes("manageragency")) {
    
    return <ResponsableAgenceDashboard />;
  } else if (roles.includes("employee")) {
    console.log("Rendering Employee Dashboard")
    return <EmployeDashboard />;
  } else if (roles.includes("client")) {
    
    return <ClientDashbord />;
  } else {
    
    // If no matching role, return a default UI or message
    return <div>No access or role not found.</div>; 
  }
}