
  'use client';

import Grid from '@mui/material/Unstable_Grid2';
import Container from '@mui/material/Container';
import Typography from '@mui/material/Typography';

import {
  _appCollaborators,
} from '@/shared/_mock';
import { useSettingsContext } from '@/shared/components/settings';
import AnalyticsConversionRates from './analytics-conversion-rates';
import AppTopCollaborator from './app-top-collaborator';
import { Card, CardContent, CardHeader, Stack ,useTheme} from '@mui/material';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { useState } from 'react';
import { DesktopDatePicker } from '@mui/x-date-pickers';


// ----------------------------------------------------------------------

export default function RewardView() {
    const settings = useSettingsContext();
   
    const [selectedDateGraphe3, setSelectedDateGraphe3] = useState<Date | null>(new Date());
    
  return (
    <LocalizationProvider dateAdapter={AdapterDateFns}>
    <Container maxWidth={settings.themeStretch ? false : 'xl'}>
        <Typography
            variant="h4"
            sx={{
              mb: { xs: 3, md: 5 },
           
            }}
          >
            Do more tasks to be included in this statistic
        </Typography>
        
     
  
      <Grid container spacing={3}>
        

        <Grid xs={12} md={6} lg={8}>
          <Card>
            <CardHeader title="he grades obtained by each employee" />
              <Stack spacing={3} direction={'row'} sx={{ ml: 2, mt: 2 }}>
                <div style={{ display: 'flex', alignItems: 'center' }}>
                  <DesktopDatePicker
                    label="Date"
                    value={selectedDateGraphe3}
                    minDate={new Date('2017-01-01')}
                    onChange={(newValue) => {
                      setSelectedDateGraphe3(newValue);
                    }}
                    slotProps={{
                      textField: {
                        fullWidth: false,
                      },
                    }}
                  />
                </div>
              </Stack>
            <AnalyticsConversionRates
           
            subheader="The scores for the last reward"
            chart={{
              series: [
                { label: 'John', value: 400 },
                { label: 'Alison', value: 430 },
                { label: 'Aryana', value: 448 },
                { label: 'Joel', value: 470 },
                { label: 'David', value: 540 },
                { label: 'Mariya', value: 580 },
                { label: 'Jan', value: 690 },
                { label: 'Lucian', value: 1100 },
                { label: 'Deja ', value: 1200 },
                { label: 'Simon', value: 1380 },
              ],
            }}
           />
          </Card>
        </Grid>
        
        <Grid xs={12} md={6} lg={4} sx={{ display: 'flex', flexDirection: 'column' }}>
          <Card sx={{ flexGrow: 1 }}>
            <AppTopCollaborator title="Top Collaborators" list={_appCollaborators} />
          </Card>
        </Grid>
        
      </Grid>
      
    </Container>
    </LocalizationProvider>
  );
}
