'use client'

import { Button, Container, Grid } from "@mui/material"
import AppWelcome from "../rewards/all-winners/app-welcome"
import { SeoIllustration } from "@/shared/assets/illustrations"
import { useSettingsContext } from "@/shared/components/settings";
import Iconify from "@/shared/components/iconify";
import { paths } from "@/routes/paths";
import { RouterLink } from "@/routes";
import CustomBreadcrumbs from "@/components/custom-breadcrumbs";
import TransferListView from "./tableau-file-transfer";

export default function ListTransferFile()
{
const settings = useSettingsContext();

return (
    <Container maxWidth={settings.themeStretch ? false : 'xl'}>
      <CustomBreadcrumbs
          heading="List"
          links={[
            {
              name: 'Dashboard',
              href: paths.dashboard.root,
            },
            {
              name: 'List Transfers',
             
            },
            
          ]}
          action={
           <Button
              component={RouterLink}
              href={paths.dashboard.transfer.new}
              variant="contained"
              sx={{
                backgroundColor: '#144dd5',
                '&:hover': {
                  backgroundColor: '#144dd5',
                },
            
                textTransform: 'none',
                px: 2,
                marginLeft: 2,
              }}
              startIcon={<Iconify icon="mingcute:add-line" />}
            >
              New Transfer
            </Button>
          }
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        />
      <Grid container spacing={3}>
       

     </Grid>
     <TransferListView/>
    </Container>
        )}

        