export type Address = {
    primaryAddresse: string;
    optionalAddress?: string;
    city: string;
    country: string;
    postalCode: string;
  };

  export type IAgency = {
    id: string;
    name: string;
    agencyName?: string;
    email?: string;
    users?: any[]; 
    status?: string; 
    phoneNumber?: string;
    address?: Address; 
    picture?: string; 
    description?: string; 
    participants?: Participants[]; 
    createDate?: Date; 
    currency?: string; 
  };
export type Participants = {
      id: string;
      name: string;
      avatarUrl: string;
      phoneNumber: string;
      email:string
};
export interface IAgencyNotification {
  id: string;
  agencyId: string;
  agencyName: string;
  message: string;
  status: string;
  description: string;
  createDate: number[];
  phoneNumber: string;
  address: {
    primaryAddresse: string;
    optionalAddress?: string;
    city: string;
    country: string;
    postalCode: string;
  };
}

//
export type IAgencyTableFilters =
{
name: string;
}
export type IAgencyTableFilterValue = string  | null;
