'use client'

import { paths } from "@/routes/paths";
import CustomBreadcrumbs from "@/shared/components/custom-breadcrumbs";
import { useSettingsContext } from "@/shared/components/settings";
import { Container } from "@mui/material";
import AgencyEditForm from "@/shared/sections/agency/agency-edit-form";

export default function CreateAgency() {
  const settings = useSettingsContext();
  
  return (
    <Container maxWidth={settings.themeStretch ? false : 'lg'}>
      <CustomBreadcrumbs
        heading="Create"
        links={[
          {
            name: 'Dashboard',
            href: paths.dashboard.root,
          },
          {
            name: 'Agency',
            href: paths.dashboard.agency.list,
          },
          {name : 'New agency'},
         
        ]}
        sx={{
          mb: { xs: 3, md: 5 },
        }}
      />
  
      <AgencyEditForm  />
    </Container>
  );
}
  