'use client'
import TransferNewFile from '@/shared/sections/transfer-file/transfer-new-file';
import { Container, Grid } from '@mui/material';
import { useSettingsContext } from "@/shared/components/settings";
import CustomBreadcrumbs from '@/shared/components/custom-breadcrumbs';
import { paths } from '@/routes/paths';
import AppWelcome from '@/shared/sections/transfer-file/app-welcome';
import { SeoIllustration } from '@/shared/assets/illustrations';

// ----------------------------------------------------------------------



export default function TransferFilePage() {
  const settings = useSettingsContext();
  return (
    <Container maxWidth={settings.themeStretch ? false : 'lg'}>
      <CustomBreadcrumbs
          heading="New Transfer"
          links={[
            {
              name: 'Dashboard',
              href: paths.dashboard.root,
            },
            {
              name: 'List Transfers',
              href: paths.dashboard.transfer.root,
            },
            {
              name: 'New',
            },
          ]}
         
          sx={{
            mb: { xs: 3, md: 5 },
          }}
        />
        <Grid xs={12} md={12} container spacing={1} sx={{justifyContent: 'center'}} >
          <AppWelcome
        description={`File transfer allows you to send large files \n It's simple and efficient. `}
        img={<SeoIllustration />}
            
          />
        </Grid>
        <TransferNewFile />

</Container>
  )
}
