// ----------------------------------------------------------------------
import { IKanbanColumn } from "@/shared/types/kanban";
import { Project } from "./Project";
import { string } from "yup";

export type ITaskTableFilterValue =
  | string
  | IManager[]
  | string[]
  | IKanbanColumn
  | Date
  | null;

export type ITaskTableFilters = {
  name: string;
  manager: IManager[];
  type: string[];
  column: IKanbanColumn;
  startDate: Date | null;
  endDate: Date | null;
  status?: string;
};

export type IUser ={
  id:number;
  firstName: string;
  lastName: string;
  email:string;
  // Add other properties if necessary
};

export type IManager = {
  id: number;
  name: string;
  avatarUrl: string;
  user: IUser;
};

// ----------------------------------------------------------------------

// Collaborator types
export type ICollaborator = {
  id: number;
  name: string;
  avatarUrl: string;
  phoneNumber: string;
  email: string;
};

export type collaborator = {
  id: number;
  successCount: number | null;
  user: {
    firstName: string;
    lastName: string;
    email: string;
    phoneNumber: string;
  };
};

// ----------------------------------------------------------------------

// Task comment and shared types
export type ITaskComment = {
  id: string;
  name: string;
  message: string;
  avatarUrl: string;
  messageType: "image" | "text";
  createdAt: Date;
};

export type ITaskShared = {
  id: string;
  name: string;
  email: string;
  avatarUrl: string;
  permission: string;
};

export type IUnderTask = {
  id: number;
  name: string;
  task: ITaskItem;
  collaboratorId: number;
};
export type Attachment = {
  id: number;
  name: string;
  type: string;
  url: string;
  createdAt: string;
};
// Task item and related types
export type ITaskItem = {
  id: number;
  name: string;
  priority: string;
  status: string;
  type: string;
  endDate: string;
  startDate: string;
  description: string;
  point: number;
  itemStates: string;
  lastModification: string | null;
  deletedAt: string | null;
  column: IKanbanColumn;
  history: Array<{
    id: number;
    action: string;
    date: string;
    userId: number | null;
    modifiedFields: string;
  }>;
  comment: any[];
  subTask: any[];
  observerIds: ICollaborator[];
  managerId: number | null;
  collaboratorIds: number[];
  attachments: Attachment[];
  projectId: number;
  project: {
    id: number;
    name: string;
  };
  shared: ITaskShared[] | null;
  url: string;
  tags: string[];
  color?: string;
  orderIndex?: number;  
};

export type CommentItem = {
  id?: number;
  message: string;
  messageType?: string;
  createdAt?: Date;
  type: string;
  idTask: number;
  isLiked?: boolean;
  collaboratorId?: number;
  tagUser?: string;
  attachments: Attachment[];
};

export type CommentReplyItem = {
  commentId: number;
  message: string;
  messageType: string;
};

export type ReplyComment = {
  id: number;
  message: string;
  messageType: string;
  createdAt: Date;
  tagUser: string;
  isLiked: string;
  comment: CommentItem;
  idUser: number;
};
