'use client';

import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { LocalizationProvider as MuiLocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';

import { useLocales } from './use-locales';
import {
  fr
} from 'date-fns/locale';


// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

export default function LocalizationProvider({ children }: Readonly<Props>) {
  return (
    <MuiLocalizationProvider dateAdapter={AdapterDateFns} adapterLocale={fr}>
      {children}
    </MuiLocalizationProvider>
    
  );
}
