import { _mock } from "./_mock";
import { _tasks } from "./_task";
import { _tags } from "./assets";

export const _Participants = [...Array(12)].map((_, index) => ({
  id: index,
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  phoneNumber: _mock.phoneNumber(index),
  email: _mock.email(index)
}));



const shared = (index: number) =>
  (index === 0 && _Participants.slice(0, 5)) ||
  (index === 1 && _Participants.slice(5, 9)) ||
  (index === 2 && _Participants.slice(9, 11)) ||
  (index === 3 && _Participants.slice(5, 8)) ||
  (index === 4 && _Participants.slice(0, 5)) ||
  (index === 5 && _Participants.slice(7, 9)) ||
  (index === 6 && _Participants.slice(4, 9)) ||
  (index === 7 && _Participants.slice(5, 9)) ||
  (index === 8 && _Participants.slice(3, 8)) ||
  (index === 9 && _Participants.slice(6, 8)) ||
  (index === 10 && _Participants.slice(6, 11)) ||
  (index === 11 && _Participants.slice(6, 11)) ||
  (index === 12 && _Participants.slice(6, 11)) ||
  [];

export const _teamWorkload = [...Array(5)].map((_, index) => {

  return {
    id: _mock.id(index),

    percent: _mock.number.percent(index),
    rank: `Top ${index + 1}`,
    email: _mock.email(index),
    name: _mock.fullName(index),
    count: Math.floor(Math.random() * 100),
    avatarUrl: _mock.image.avatar(index + 8),
  };
});

export const _appCollaborators = [...Array(7)].map((_, index) => ({
  id: _mock.id(index),
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  totalFavorites: _mock.number.nativeL(index),
}));

export const PROJECT_TYPE_OPTIONS = [
  'EXTERNAL',
  'INTERNAL'
];
export const PROJECT_STATUS_OPTIONS = [
  'In progress',
  'Completed',
  'Pending',
];

const PROJECTS = [
  { title: 'Projet Mu', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Nu', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Xi', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Omicron', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Pi', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Rho', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Sigma', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Tau', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Upsilon', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Phi', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Alpha', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Beta', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Gamma', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Delta', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Épsilon', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Zêta', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Theta', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Iota', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Kappa', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Lambda', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Mu', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Nu', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Xi', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Omicron', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Pi', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Rho', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Sigma', status: PROJECT_STATUS_OPTIONS[4], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Tau', status: PROJECT_STATUS_OPTIONS[1], type: PROJECT_TYPE_OPTIONS[1] },
  { title: 'Projet Upsilon', status: PROJECT_STATUS_OPTIONS[2], type: PROJECT_TYPE_OPTIONS[0] },
  { title: 'Projet Phi', status: PROJECT_STATUS_OPTIONS[0], type: PROJECT_TYPE_OPTIONS[1] }
];

export const _project = PROJECTS.map((title, index) => ({
  title: PROJECTS[index].title,
  id: `${_mock.id(index)}_project`,
  Participants: shared(index),
  EndDate:  new Date(),
  StartDate: _mock.time(index+8),
  description: `An interactive platform offering online courses in various fields, allowing users to learn at their own pace.`,
  type: PROJECTS[index].type,
  status: PROJECTS[index].status,
  tasks: _tasks,
  isFavorited:true,
  isDeleted:true,
  isArchived:true,
  DeletedAt:_mock.time(index),
  DeletedBy:_Participants[1]
}));

