import { _mock } from "./_mock";
import { _tasks } from "./_task";



export const REWARD_PUBLISH_OPTIONS = [
  {
    value: 'published',
    label: 'Published',
  },
  {
    value: 'draft',
    label: 'Draft',
  },
];
export const _notes = [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 30, 35, 40];
export const REWARD_SORT_OPTIONS = [
  { value: 'latest', label: 'Latest' },
  { value: 'popular', label: 'Popular' },
  { value: 'oldest', label: 'Oldest' },
];
export const _Author = [...Array(12)].map((_, index) => ({
  id: _mock.id(index),
  role: _mock.role(index),
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  phoneNumber: _mock.phoneNumber(index),
  email: _mock.email(index)
}));
export const _Winners = [...Array(12)].map((_, index) => ({
  id: _mock.id(index),
  role: _mock.role(index),
  name: _mock.fullName(index),
  avatarUrl: _mock.image.avatar(index),
  phoneNumber: _mock.phoneNumber(index),
  email: _mock.email(index),
  reward: _mock.boolean(index),
  note: _notes[index]
}));
const ListRewards = [
  "Monthly bonus",
  "Amazon gift card",
  "Stay in a luxury hotel",
  "Gourmet meal",
  "Spa session",
  "Tickets to a concert",
  "Hot air balloon flight experience",
  "VIP access to a sports event",
  "High-end sports equipment",
  "Cooking class with a renowned chef",
  "Professional photo shoot",
  "Tickets to an amusement park"
];


export const Rules = [
  {
    "label": "Fix The threshold",
    "threshold": 12
  },
  {
    "label": "the highest of grades",
    "threshold": ""
  }
]



const description = "Occaecati est et illo quibusdam accusamus qui. enetur facilis. Ut omnis voluptates nihil accusantium doloribus eaque debitis.";
export const _rewards = [...Array(12)].map((_, index) => {
  const status = index % 3 ? 'Published' : 'Draft';
  const Rule = index % 3 ? Rules[0].label + " " + Rules[0].threshold : Rules[1].label + " " + Rules[1].threshold;
  const Price = _mock.number.price(index)

  return {
    id: _mock.id(index),
    title: ListRewards[index],
    description: description,
    StartDate: new Date(),
    EndDate: _mock.time(index),
    status: status,
    author: _Author[index],
    Rule: Rule,
    Price: Price,
    tasks: _tasks,
    winners: _Winners[index]
  };
});
