
import { axiosInstance } from '@/utils/axios';
import { Permission, PermissionUpdateRequest } from '../types/permission';
import { AccessLevel } from './file-manager';



export const permissionApi = {
  getPermission: async (documentId: number, userId: number): Promise<Permission> => {
    const response = await axiosInstance.get(`/api/file/permissions/${documentId}`, {
      params: { userId }
    });
    return response.data;
  },

  getAllPermissions: async (documentId: number): Promise<Permission[]> => {
    const response = await axiosInstance.get(`/api/file/permissions/${documentId}/all`);
    return response.data;
  },

  updatePermission: async (documentId: number, request: PermissionUpdateRequest): Promise<Permission> => {
    const response = await axiosInstance.put(`/api/file/permissions/${documentId}`, request);
    return response.data;
  },

  revokePermission: async (documentId: number, userId: number): Promise<void> => {
    await axiosInstance.delete(`/api/file/permissions/${documentId}`, {
      params: { userId }
    });
  },

  checkPermission: async (documentId: number, userId: number, requiredLevel: AccessLevel): Promise<boolean> => {
    const response = await axiosInstance.get(`/api/file/permissions/${documentId}/check`, {
      params: { userId, requiredLevel }
    });
    return response.data;
  }
};